﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Public Sub New()
        InitializeComponent()

        ' Get PathGeometry from resource
        Dim catPath = TryCast(Me.Resources("catPath"), Path)
        Dim _pathGeometry = TryCast(catPath.Data, PathGeometry)
        catPath.Data = Nothing

        ' Get geometry bounds
        Dim bounds = _pathGeometry.Bounds

        ' Create new path for rendering on bitmap
        Dim newPath = New Path With
                      {.Stroke = TryCast(Me.Resources("PhoneForegroundBrush"), Brush),
                       .StrokeThickness = 5,
                       .Data = _pathGeometry}

        ' Create the WriteableBitmap
        Dim writeableBitmap As New WriteableBitmap(CInt(bounds.Width + newPath.StrokeThickness),
                                                   CInt(bounds.Height + newPath.StrokeThickness))

        ' Color the background of the bitmap
        Dim baseColor = CType(Me.Resources("PhoneAccentColor"), Color)

        ' Treat the bitmap as an ellipse:
        '  radiusX and radiusY are also the centers!
        Dim radiusX = writeableBitmap.PixelWidth / 2.0
        Dim radiusY = writeableBitmap.PixelHeight / 2.0

        For y = 0 To writeableBitmap.PixelHeight - 1
            For x = 0 To writeableBitmap.PixelWidth - 1
                Dim angle = Math.Atan2(y - radiusY, x - radiusX)
                Dim ellipseX = radiusX * (1 + Math.Cos(angle))
                Dim ellipseY = radiusY * (1 + Math.Sin(angle))

                Dim ellipseToCenter = Math.Sqrt(Math.Pow(ellipseX - radiusX, 2) +
                                                Math.Pow(ellipseY - radiusY, 2))

                Dim pointToCenter = Math.Sqrt(Math.Pow(x - radiusX, 2) +
                                              Math.Pow(y - radiusY, 2))

                Dim opacity = Math.Min(1, pointToCenter / ellipseToCenter)

                Dim A = CInt(opacity * 255)
                Dim R = CInt(opacity * baseColor.R)
                Dim G = CInt(opacity * baseColor.G)
                Dim B = CInt(opacity * baseColor.B)

                Dim color = A << 24 Or R << 16 Or G << 8 Or B

                writeableBitmap.Pixels(y * writeableBitmap.PixelWidth + x) = color
            Next x
        Next y

        writeableBitmap.Invalidate()

        ' Find transform to move Path to edges
        Dim translate = New TranslateTransform With
                        {.X = -bounds.X + newPath.StrokeThickness / 2,
                         .Y = -bounds.Y + newPath.StrokeThickness / 2}

        writeableBitmap.Render(newPath, translate)
        writeableBitmap.Invalidate()

        ' Set bitmap to Image element
        img.Source = writeableBitmap
    End Sub
End Class